//Listing 13.3. Przykad oddzielnych klas dla rnych podtypw obiektw.
#include <iostream>
using namespace std;

class CheckingAccount {
  double balance;
  double fee; // brak oprocentowania

public:
  CheckingAccount(double initBalance)
  { balance = initBalance; fee = 0.2; } // rachunek rozliczeniowy

  double getBal()
  { return balance; } // wsplna dla obu rachunkw

  void withdraw(double amount)
  { if (balance > amount)
      balance = balance - amount - fee; } // bezwarunkowe obcienie transakcji

  void deposit(double amount)
  { balance += amount; }
} ;

class SavingsAccount {
  double balance;
  double rate; // brak prowizji

public:
  SavingsAccount(double initBalance)
  { balance = initBalance; rate = 6.0; } // rachunek oszczdnociowy

  double getBal()
  { return balance; } // wsplna dla obu rachunkw

  void withdraw(double amount) // wsplna dla obu rachunkw
  { if (balance > amount)
      balance -= amount; }

  void deposit(double amount)
  { balance += amount; }

  void payInterest() // jedynie dla rachunkw oszczdnociowych
  { balance += balance * rate / 365 / 100; }
} ;

int main()
{
  CheckingAccount a1(1000); // a1: rozliczeniowy
  SavingsAccount a2(1000); // a2: oszczdnociowy
  cout << " Pocztkowe stany kont: " << a1.getBal()
  << " " << a2.getBal() << endl;
  a1.withdraw(100); a2.deposit(100); // nie wystpuje aden problem
  //a1.payInterest(); // w tym momencie jest to bd skdni!!
  a2.payInterest(); // wyraenie poprawne
  cout << " Kocowe stany kont: " << a1.getBal()
  << " " << a2.getBal() << endl;
  return 0;
}
